<?php
namespace UiCoreElements;
use Elementor\Widget_Base;
use UiCoreElements\Helper;

abstract class UiCoreWidget extends Widget_Base {

    /**
     * Get widget categories.
     *
     * @return object ['assets-name' => ['condition' => ['key' => 'value'] , 'deps' => ['global-handler-name','other-handler-name']]]
     */
    public abstract function get_styles();

    /**
     * Get widget categories.
     *
     * @return object ['assets-name' => ['condition' => ['key' => 'value'] , 'deps' => ['global-handler-name','other-handler-name']]]
     */
    public abstract function get_scripts();

    public function get_style_depends()
    {
        $assets = $this->get_styles();
        $final_list = $this->parse_asset_list($assets,'style');

        //TODO: combine all the styles into one file and return it
        return $final_list;
    }

    public function get_script_depends()
    {
        $assets = $this->get_scripts();
        $final_list = $this->parse_asset_list($assets,'script');

        //TODO: combine all the styles into one file and return it
        return $final_list;
    }



    private function parse_asset_list($list,$type='style'){
        $final_list = [];
        foreach ($list as $key => $value) {
            $deps = (isset($value) && isset($value['deps'])) ? $value['deps'] : [];
            $name = $this->get_asset_name($key,$value);

            //if name is not empty then we need to add it to the list
            if($name){
                $method_name = "register_widget_$type";
                $final_list[] = Helper::$method_name($name,$deps);
            }
        }
        return $final_list;
    }

    private function get_asset_name($key,$value){
        //check the condition/s
        if (\is_array($value) && !empty($value)) {
            //check if the condition is true using elementor's function (always return true if we are in edit mode)
            if($this->is_edit_mode() || $this->is_control_visible($value,$this->get_settings())){
                return $key;
            }else{
                return '';
            }
            //this is the same but done manually (eg:remove this if we don;t have problems with it)
            // foreach ($value as $k => $v) {
            //     if(\is_array($v)){
            //         return $this->get_asset_name($k,$v);
            //     }else{
            //         $this->is_control_visible(['con'])
            //         if($this->get_settings($k) == $v){
            //             return $key;
            //         }else{
            //             return '';
            //         }
            //     }
            // }
        }
        // if list is only declaring the assets without any condition then we need to return the key
        return $value;

    }
    protected function is_edit_mode() {
        $elementor_instance = \Elementor\Plugin::instance();
        if ( $elementor_instance->preview->is_preview_mode() || $elementor_instance->editor->is_edit_mode() ) {
            return true;
        }

        return false;
    }


}
